/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: DefaultElement.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.kdom;

import java.util.*;
import de.kxml.*;

/**
 * A default implementation of the abstract Element class
 */
public class DefaultElement extends Element {
    protected String       namespace;
    protected String       name;
    protected Vector       children;
    protected Vector       attributes;
    protected StringBuffer types;
    protected Object       parent;
    protected PrefixMap    prefixMap;

    /**
     * please use Document.createElement instead of invoking the
     * constructor directly, giving the corresponding Document
     * subclass a chance to create custom elements
     */
    public DefaultElement(Object parent, String namespace, String name, 
			  Vector attributes) {
	this.parent = parent;
	this.namespace = namespace == null ? Xml.NO_NAMESPACE : namespace;
	this.name = name;
	this.attributes = attributes;
    }

    /**
     * Method declaration
     *
     *
     * @param index
     * @param type
     * @param child
     *
     * @see
     */
    public void addChild(int index, int type, Object child) {
	if (child == null) {
	    throw new NullPointerException();
	} 

	if (children == null) {
	    types = new StringBuffer();
	    children = new Vector();
	} 

	if (type == Xml.ELEMENT) {
	    if (!(child instanceof Element)) {
		throw new RuntimeException("invalid child type");
	    } 

	    ((Element) child).setParent(this);
	} else if (type == Xml.TEXT || type == Xml.COMMENT 
		   || type == Xml.PROCESSING_INSTRUCTION) {
	    if (!(child instanceof String)) {
		throw new RuntimeException("invalid child type");
	    } 
	} else {
	    throw new RuntimeException("invalid child type");
	}

	children.insertElementAt(child, index);
	types.insert(index, (char) type);
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @return
     *
     * @see
     */
    public Attribute getAttribute(int index) {
	return (Attribute) attributes.elementAt(index);
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public int getAttributeCount() {
	return attributes == null ? 0 : attributes.size();
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public Vector getAttributes() {
	return attributes;
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @return
     *
     * @see
     */
    public Object getChild(int index) {
	return children.elementAt(index);
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public int getChildCount() {
	return children == null ? 0 : children.size();
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public String getName() {
	return name;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public String getNamespace() {
	return namespace;
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @return
     *
     * @see
     */
    public int getType(int index) {
	return types.charAt(index);
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public Document getDocument() {
	return (parent instanceof Document) || parent == null 
	       ? (Document) parent : ((Element) parent).getDocument();
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public Element getParentElement() {
	return (parent instanceof Document) ? null : ((Element) parent);
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @see
     */
    public void removeAttribute(int index) {
	attributes.removeElementAt(index);
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @see
     */
    public void removeChild(int index) {
	children.removeElementAt(index);
    } 

    /**
     * Method declaration
     *
     *
     * @param attr
     *
     * @see
     */
    public void setAttribute(Attribute attr) {
	throw new RuntimeException("not yet implemented");
    } 

    /**
     * Method declaration
     *
     *
     * @param attributes
     *
     * @see
     */
    public void setAttributes(Vector attributes) {
	this.attributes = attributes;
    } 

    /**
     * sets the name of the element
     */
    public void setName(String name) {
	this.name = name;
    } 

    /**
     * sets the namespace of the element
     */
    public void setNamespace(String namespace) {
	this.namespace = namespace == null ? Xml.NO_NAMESPACE : namespace;
    } 

    /**
     * Method declaration
     *
     *
     * @param parent
     *
     * @see
     */
    public void setParent(Object parent) {
	this.parent = parent;
    } 

    /**
     * Method declaration
     *
     *
     * @param prefixMap
     *
     * @see
     */
    public void setPrefixMap(PrefixMap prefixMap) {
	this.prefixMap = prefixMap;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public PrefixMap getPrefixMap() {
	return prefixMap;
    } 

}

